﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/Public.master" CodeBehind="login.aspx.vb" Inherits="Web.Login" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <script type="text/javascript">
        function pageLoad() {
            var mpe = '<%= MPE_PanelErrores.ClientID %>';
            var background = $get(mpe + '_backgroundElement');
            if (background) $addHandler(background, 'click', hideModalPopupViaClient);
            return false;
        }
        function hideModalPopupViaClient() {
            var modalPopupBehavior = $find('<%= MPE_PanelErrores.ClientID %>');
            if (modalPopupBehavior) modalPopupBehavior.hide();
        }
    </script>

    <asp:UpdatePanel runat="server" ID="UpdatePanelLogin" UpdateMode="Conditional">
        <ContentTemplate>

            <!-- Ponemos el focus en el campo de texto de la contraseña -->
            <script type="text/javascript">
                function SetFocus() {
                    document.getElementById('<%=Contraseña.ClientID%>').focus();
                }
                window.onload = function () { SetFocus(); }
            </script>

            <div class="login-form">
                <fieldset>
                    <div class="holder">
                        <div class="row">
                            <asp:TextBox placeholder="Login" ID="txtLogin" runat="server" CssClass="input" Text=""></asp:TextBox>
                        </div>
                        <div class="row">
                            <asp:TextBox placeholder="Contraseña" ID="Contraseña" TextMode="Password" runat="server" CssClass="input"></asp:TextBox>
                        </div>
                        <div class="submit-holder">
                            <asp:LinkButton ID="btn_Entrar" CssClass="btn" runat="server" OnClick="btn_Entrar_Click"><%= Translator.Translate("ADMIN_BTN_ENTER")%></asp:LinkButton>
                            <asp:LinkButton ID="btn_cancel" CssClass="btn" runat="server" Style="float: right;" OnClick="btn_cancel_Click"><%= Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
                        </div>
                        <div class="row">
                            <a href="password-recovery.aspx"><%= Translator.Translate("MSG_LOGIN_FORGETPASSWORD")%></a>
                        </div>
                        <div class="row">
                            <asp:LinkButton ID="btnIdioma" runat="server" OnClick="btnIdioma_Click"></asp:LinkButton>
                        </div>
                    </div>

                    <!--Panel de errores del formulario de login -->
                    <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                        <div class="holder">
                            <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                            <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn">Ok</a>
                        </div>
                    </asp:Panel>

                    <!-- controles ajax-->
                    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

                    <!-- controles ocultos-->
                    <asp:HiddenField ID="hdnPanelErrores" runat="server" />

                    <!--Panel de actualización -->
                    <asp:Panel ID="PanelActualiza" runat="server" Style="display: none" CssClass="error-message">
                        <div class="holder">
                            <asp:Literal ID="info_PanelActualiza" runat="server"></asp:Literal>
                            <br />
                            <asp:LinkButton ID="btnAceptar_PanelActualiza" runat="server" CssClass="btn" OnClick="btnAceptar_PanelEntradaDatos_Click"><%= Translator.Translate("INSTALL_BTN_UPDATE")%></asp:LinkButton>
                            <asp:LinkButton ID="btnCancelar_PanelActualiza" runat="server" CssClass="btn" OnClick="btnCancelar_PanelActualiza_Click"><%= Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
                        </div>
                    </asp:Panel>

                    <!-- controles ajax-->
                    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelActualiza" runat="server" TargetControlID="hdnPanelActualiza" PopupControlID="PanelActualiza" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID="" />

                    <!-- controles ocultos-->
                    <asp:HiddenField ID="hdnPanelActualiza" runat="server" />

                    <!--Panel de idioma -->
                    <asp:Panel ID="PanelIdioma" runat="server" Style="display: none" CssClass="error-message">
                        <div class="holder">
                            <asp:DropDownList ID="Idioma" runat="server" CssClass="input" Style="margin: 0 auto; width: 200px;"></asp:DropDownList><br />
                            <asp:LinkButton ID="btnAceptar_Idioma" runat="server" CssClass="btn" OnClick="btnAceptar_Idioma_Click"></asp:LinkButton>
                            <asp:LinkButton ID="btnCancelar_Idioma" runat="server" CssClass="btn"></asp:LinkButton>
                        </div>
                    </asp:Panel>

                    <!-- controles ajax-->
                    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelIdioma" runat="server" TargetControlID="hdnPanelIdioma" PopupControlID="PanelIdioma" BackgroundCssClass="" CancelControlID="btnCancelar_Idioma" DropShadow="false" PopupDragHandleControlID="" />

                    <asp:HiddenField ID="hdnPanelIdioma" runat="server" />
                </fieldset>
            </div>

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btn_Entrar" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>

    <!-- UpdateProgressLogin -->
    <asp:UpdateProgress ID="UpdateProgressLogin" runat="server" AssociatedUpdatePanelID="UpdatePanelLogin" DisplayAfter="100" Visible="true">
        <ProgressTemplate>
            <asp:Image ID="img_ajax_loading" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
        </ProgressTemplate>
    </asp:UpdateProgress>

    <!-- UpdatePanelAnimationExtender -->
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderLogin" TargetControlID="UpdatePanelLogin" BehaviorID="animation" runat="server">
        <Animations>
            <OnUpdating>
                <Sequence>
                    <ScriptAction Script="LockScreen();" />
                </Sequence>
            </OnUpdating>
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="UnlockScreen();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Content>
